<?php

/**
 * @psalm-suppress PropertyNotSetInConstructor
 */
class Awardit_Altapay_Model_Quote extends Mage_Sales_Model_Quote
{
    /**
     * Check is order increment id use in sales/order table
     *
     * @param string|int $reservedOrderId
     *
     * @return bool
     */
    public function isReservedOrderIdUsed($reservedOrderId)
    {
        $resource  = $this->_getResource();
        $adapter   = $resource->getReadConnection();
        $bind      = [':reserved_order_id' => (string)$reservedOrderId];
        $select    = $adapter->select();
        $select->from($resource->getTable('sales/quote'), 'entity_id')
            ->where('reserved_order_id = :reserved_order_id');

        if ($this->getId() > 0) {
            $bind[':entity_id'] = $this->getId();
            $select->where('entity_id <> :entity_id');
        }

        $entity_id = $adapter->fetchOne($select, $bind);
        if ($entity_id > 0) {
            return true;
        }

        return false;
    }

    /**
     * Generate new increment order id and associate it with current quote
     *
     * @return $this
     */
    public function reserveOrderId()
    {
        parent::reserveOrderId();

        //checking if reserved order id was already used for some quote
        //if yes reserving new one if not using old one
        if ($this->isReservedOrderIdUsed($this->getReservedOrderId())) {
            $this->setReservedOrderId($this->_getResource()->getReservedOrderId($this));
        }

        return $this;
    }
}
