<?php

use Mage_Sales_Model_Resource_Order_Grid_Collection as ParentClass;

class Awardit_AdminExtensions_Model_Resource_Order_GridCollection extends ParentClass
{
    protected function _construct(): void
    {
        parent::_construct();
        $this->setMainTable('sales/order_grid');
    }

    public function getSelectCountSql(): string
    {
        return Mage_Sales_Model_Resource_Collection_Abstract::getSelectCountSql();
    }

    /**
     * @param string|array<string,string> $table
     * @param string $cond
     * @param string|array<string> $cols
     */
    public function leftJoin($table, $cond, $cols = '*'): self
    {
        if (is_array($table)) {
            $alias = key($table);
            $table = current($table);
        } else {
            $alias = $table;
        }
        /** @var string $alias */
        if (!isset($this->_joinedTables[$alias])) {
            $this->getSelect()->joinLeft(
                [$alias => $this->getTable($table)],
                $cond,
                $cols
            );
            $this->_joinedTables[$alias] = true;
        }
        return $this;
    }
}
