<?php

class Awardit_AdminExtensions_Helper_Data extends Mage_Core_Helper_Abstract
{
    /**
     * Get currencies for option field.
     * @return array<array-key, mixed>
     */
    public function getCurrencyOptions(): array
    {
        $currencies = Mage::getModel('directory/currency')->getConfigAllowCurrencies();
        sort($currencies);
        return array_combine($currencies, $currencies);
    }

    /**
     * Get countries for option field.
     * @return array<array-key, mixed>
     */
    public function getCountryOptions(): array
    {
        $countries = [];
        foreach (Mage::helper('directory')->getCountryCollection() as $code => $country) {
            $countries[$code] = $country->getName();
        }
        return $countries;
    }

    /**
     * Get stores for option field.
     * @return array<array-key, mixed>
     */
    public function getStoreOptions(): array
    {
        $stores = [];
        foreach (Mage::app()->getStores() as $store) {
            $stores[$store->getId()] = $store->getName();
        }
        asort($stores);
        return $stores;
    }

    /**
     * Get order statues for option field.
     * @return array<array-key, mixed>
     */
    public function getOrderStatusOptions(): array
    {
        $statuses = Mage::getSingleton('sales/order_config')->getStatuses();
        asort($statuses);
        return $statuses;
    }
    /**
     * Get order states for option field.
     * @return array<array-key, mixed>
     */
    public function getOrderStateOptions(): array
    {
        $states = Mage::getSingleton('sales/order_config')->getStates();
        asort($states);
        return $states;
    }

    /**
     * Get order shipping methods for option field.
     * @return array<array-key, mixed>
     */
    public function getShippingMethodOptions(): array
    {
        $methods = [];
        foreach (Mage::getSingleton('shipping/config')->getAllCarriers() as $code => $_carrier) {
            if (Mage::getStoreConfig("carriers/{$code}/active")) {
                $methods[$code] = Mage::getStoreConfig("carriers/{$code}/title");
            }
        }
        asort($methods);
        return $methods;
    }

    /**
     * Get product types for option field.
     * @return array<array-key, mixed>
     */
    public function getProductTypeOptions(): array
    {
        return Mage::getSingleton('catalog/product_type')->getOptionArray();
    }

    /**
     * Get attribute sets for option field.
     * @return array<array-key, mixed>
     */
    public function getAttributeSetOptions(): array
    {
        return Mage::getResourceModel('eav/entity_attribute_set_collection')
            ->setEntityTypeFilter(Mage::getModel('catalog/product')->getResource()->getTypeId())
            ->setOrder('attribute_set_name', 'asc')
            ->load()
            ->toOptionHash();
    }

    /**
     * Get attribute sets for option field.
     * @return array<array-key, mixed>
     */
    public function getAttributeOptions(
        Mage_Eav_Model_Entity_Attribute_Abstract $attribute,
        ?Mage_Core_Model_Store $store = null
    ): array {
        $options = Mage::getResourceModel('eav/entity_attribute_option_collection')
            ->setPositionOrder('asc')
            ->setAttributeFilter((int)$attribute->getId())
            ->setStoreFilter($store ? $store->getId() : Mage_Core_Model_App::ADMIN_STORE_ID)
            ->load();
        $values = [];
        foreach ($options as $option) {
            $values[$option->getOptionId()] = $option->getValue();
        }
        return $values;
    }
}
