# Admin Extensions

Extensions for Magento admin.

## Order list

Additional, configurable columns in order list view.

### Adding columns from module

It is possible for a module to add additional columns to the order list view by implementing an observer.

config.xml
```xml
<config>
    <global>
        <events>
            <awardit_adminextensions_order_grid>
                <observers>
                    <my_observer>
                        <type>singleton</type>
                        <class>My_Observer</class>
                        <method>addColumns</method>
                    </my_observer>
                </observers>
            </awardit_adminextensions_order_grid>
        </events>
    </global>
</config>
```

My_Observer.php
```php
class My_Observer extends Mage_Core_Model_Abstract
{
    public function addColumns(Varien_Event_Observer $observer): void
    {
        $handler = $observer->getHandler();
        $handler->enableContext(
            'my_context',
            'sales/order_payment',
            "(my_context.parent_id = main_table.entity_id)"
        );
        $handler->enableColumn([
            'context' => 'my_context',
            'column' => 'my_column',
            'header' => 'Name to show in admin',
        ]);
    }
```

### enableContext

```php
public function enableContext(string $context, string $resource, $join = null): self
```

The `enableContext()` is used when you need to join additional tables.
The following contexts are available per default:

| context | resource | join condition | database |
|-|-|-|-|
| `main_table` | `sales/order_grid` | | `sales_flat_order_grid` |
| `order` | `sales/order` | `(order.entity_id = main_table.entity_id)` | `sales_flat_order` |
| `order_payment` | `sales/order_payment` | `(order_payment.parent_id = main_table.entity_id)` | `sales_flat_order_payment` |

### enableColumn

```php
public function enableColumn(array $column, ?callable $callback = null): self
```

Use `enableColumn()` to enable a selectable column.
The `$column` definition may contain:

| key | type | comment |
|-|-|-|
| `column` | `string` | Context key, required |
| `context` | `string` | Column key, required |
| `header` | `string` | Name to show in admin, required |
| `default` | `boolean` | If columns should be shown by default (Default: `false`) |
| `type` | `string` | Type, e.g. `text`, `datetime`, `options`, `currency` (Default: `text`) |
| `options` | `array` | List of options |
| `renderer` | `string` | |
| `filter` | `string` | |
| `filter_index` | `string\|array` | |
| `column_index` | `string` | |
| `currency` | `string` | |

The callback function may be used to manipulate column further.
Callback function should follow;
```php
function (string $column, Awardit_AdminExtensions_Block_Order_Grid $object) {
    // Do things
}
```

