<?php

declare(strict_types=1);

use Crossroads\Magento\Test\Integration\MagentoManager;
use PHPUnit\Framework\TestCase;

class AdminTest extends TestCase
{
    public function testRewrite(): void
    {
        /** @var Mage_Core_Model_Config $config */
        $config = Mage::getConfig();
        $classname = $config->getBlockClassName('adminhtml/sales_order_grid');
        $this->assertEquals('Awardit_AdminExtensions_Block_Order_Grid', $classname);
        $classname = $config->getBlockClassName('adminhtml/catalog_product_grid');
        $this->assertEquals('Awardit_AdminExtensions_Block_Product_Grid', $classname);
    }

    public function testBlockClasses(): void
    {
        $class = new Awardit_AdminExtensions_Block_Config_Composer();
        $this->assertInstanceOf(Awardit_AdminExtensions_Block_Config_Composer::class, $class);
        $class = new Awardit_AdminExtensions_Block_Element_ReadOnly();
        $this->assertInstanceOf(Awardit_AdminExtensions_Block_Element_ReadOnly::class, $class);
        $class = new Awardit_AdminExtensions_Block_Filter_PrefixSelect();
        $this->assertInstanceOf(Awardit_AdminExtensions_Block_Filter_PrefixSelect::class, $class);
        $class = new Awardit_AdminExtensions_Block_Renderer_PrefixOptions();
        $this->assertInstanceOf(Awardit_AdminExtensions_Block_Renderer_PrefixOptions::class, $class);
    }
}
