<?php

/**
 * Override of admin product list.
 * Enables additional columns, and ability to configure which columns to show.
 * @psalm-suppress PropertyNotSetInConstructor
 */
class Awardit_AdminExtensions_Block_Product_Grid extends Mage_Adminhtml_Block_Catalog_Product_Grid implements
    Awardit_AdminExtensions_Common_GridInterface
{
    use Awardit_AdminExtensions_Common_GridTrait;


    protected function getCollectionClass(): string
    {
        return 'catalog/product_collection';
    }

    protected function getEventName(): string
    {
        return 'awardit_adminextensions_product_grid';
    }

    protected function addDefaults(): void
    {
        $gridHelper = Mage::helper('awardit_adminextensions');
        $catalogHelper = Mage::helper('catalog');
        $eavHelper = Mage::helper('eav');

        $this->enableContext(
            'inventory_stock_item',
            'cataloginventory/stock_item',
            "product_id=entity_id",
            null,
            ['stock_id' => '1']
        );

        $this->enableColumn('entity_id', [
            'header' => $catalogHelper->__('ID'),
            'type' => 'number',
        ], self::COL_STATIC);
        $this->enableColumn('name', [
            'attribute' => 'name',
        ], self::COL_DEFAULT);
        $this->enableColumn('type_id', [
            'header' => $catalogHelper->__('Type'),
            'type' => 'options',
            'options' => function () use ($gridHelper) {
                return $gridHelper->getProductTypeOptions();
            },
        ], self::COL_DEFAULT);
        $this->enableColumn('attribute_set_id', [
            'header' => $catalogHelper->__('Attrib, Set Name'),
            'type' => 'options',
            'options' => function () use ($gridHelper) {
                return $gridHelper->getAttributeSetOptions();
            },
        ], self::COL_DEFAULT);
        $this->enableColumn('sku', [
            'header' => $catalogHelper->__('SKU'),
            'type' => 'string',
        ], self::COL_STATIC);
        $attribute = $this->getCollection()->getAttribute('manufacturer');
        if ($attribute && $attribute->getId()) {
            $this->enableColumn('manufacturer', [
                'attribute' => $attribute,
                'type' => 'options',
                'options' => function () use ($gridHelper, $attribute) {
                    return $gridHelper->getAttributeOptions($attribute, $this->getStore());
                },
            ], self::COL_DEFAULT);
        }
        $this->enableColumn('price', [
            'attribute' => 'price',
        ], self::COL_DEFAULT);
        if ($catalogHelper->isModuleEnabled('Mage_CatalogInventory')) {
            $this->enableColumn('qty', [
                'header' => $catalogHelper->__('Qty'),
                'type' => 'number',
                'context' => 'inventory_stock_item',
                'field' => 'qty',
            ], self::COL_DEFAULT);
            $this->enableColumn('stock_manage', [
                'header' => $catalogHelper->__('Stock Mng.'),
                'type' => 'options',
                'context' => 'inventory_stock_item',
                'field' => 'manage_stock',
                'options' => [$eavHelper->__('No'), $eavHelper->__('Yes')],
            ]);
            $this->enableColumn('stock_is_in_stock', [
                'header' => $catalogHelper->__('Stock Avail.'),
                'type' => 'options',
                'context' => 'inventory_stock_item',
                'field' => 'is_in_stock',
                'options' => [$catalogHelper->__('Out of stock'), $catalogHelper->__('In Stock')],
            ]);
        }
        $this->enableColumn('visibility', [
            'attribute' => 'visibility',
            'type' => 'options',
            'options' => function () {
                return Mage::getModel('catalog/product_visibility')->getOptionArray();
            },
        ], self::COL_DEFAULT);
        $this->enableColumn('status', [
            'attribute' => 'status',
            'type' => 'options',
            'options' => function () {
                return Mage::getSingleton('catalog/product_status')->getOptionArray();
            },
        ], self::COL_DEFAULT);
        $attribute = $this->getCollection()->getAttribute('enriched');
        if ($attribute && $attribute->getId()) {
            $this->enableColumn('enriched', [
                'attribute' => $attribute,
                'type' => 'options',
                'sortable' => false,
                'options' => [$eavHelper->__('No'), $eavHelper->__('Yes')],
            ]);
        }
        $attribute = $this->getCollection()->getAttribute('awardit_dropship');
        if ($attribute && $attribute->getId()) {
            $this->enableColumn('awardit_dropship', [
                'header' => $catalogHelper->__('Dropship'),
                'attribute' => $attribute,
                'type' => 'options',
                'sortable' => false,
                'options' => [$eavHelper->__('No'), $eavHelper->__('Yes')],
            ]);
        }
        $attribute = $this->getCollection()->getAttribute('tax_class_id');
        if ($attribute && $attribute->getId()) {
            $this->enableColumn('tax_class_id', [
                'header' => $catalogHelper->__('Tax class'),
                'attribute' => $attribute,
                'type' => 'options',
                'sortable' => false,
                'options' => function () use ($gridHelper) {
                    return $gridHelper->geTaxClassOptions();
                },
            ]);
        }
        if (!Mage::app()->isSingleStoreMode()) {
            $this->enableColumn('websites', [
                //'attribute' => 'websites',
                'header' => $catalogHelper->__('Websites'),
                'type' => 'options',
                'sortable' => false,
                'options' => function () {
                    return Mage::getModel('core/website')->getCollection()->toOptionHash();
                },
            ], self::COL_DEFAULT);
        }
    }

    // Overload, to add website names
    protected function _prepareCollection(): self
    {
        $this->prepareCollection();
        Mage_Adminhtml_Block_Widget_Grid::_prepareCollection();
        $this->getCollection()->addWebsiteNamesToResult();
        return $this;
    }

    /**
     * Prepare columns.
     * @return $this
     * @psalm-suppress MoreSpecificReturnType, LessSpecificReturnStatement
     */
    protected function _prepareColumns(): self
    {
        $this->prepareColumns();

        $this->addColumn(
            'action',
            [
                'header'    => Mage::helper('catalog')->__('Action'),
                'width'     => '50px',
                'type'      => 'action',
                'getter'     => 'getId',
                'actions'   => [
                    [
                        'caption' => Mage::helper('catalog')->__('Edit'),
                        'url'     => [
                            'base' => '*/*/edit',
                            'params' => ['store' => $this->getRequest()->getParam('store')]
                        ],
                        'field'   => 'id'
                    ]
                ],
                'filter'    => false,
                'sortable'  => false,
                'index'     => 'stores',
            ]
        );

        if (
            Mage::helper('catalog')->isModuleEnabled('Mage_Rss') &&
            Mage::helper('rss')->isRssEnabled() &&
            Mage::getStoreConfigFlag('rss/catalog/notifystock')
        ) {
            $this->addRssList('rss/catalog/notifystock', Mage::helper('catalog')->__('Notify Low Stock RSS'));
        }

        return Mage_Adminhtml_Block_Widget_Grid::_prepareColumns();
    }
}
