<?php

use Composer\InstalledVersions;

class Awardit_AdminExtensions_Block_Config_Composer extends Mage_Adminhtml_Block_System_Config_Form_Fieldset
{
    public function render(Varien_Data_Form_Element_Abstract $element)
    {
        $html = $this->_getHeaderHtml($element);
        $packages = array_unique(InstalledVersions::getInstalledPackages());

        foreach ($packages as $package) {
            $version = InstalledVersions::getVersion($package);
            if (is_null($version)) {
                continue;
            }
            $html .= "<tr><td class=\"value\" style=\"widtH:auto;\"><code>{$package}</code></td>"
                  .  "<td class=\"value\"><code>{$version}</code></td></tr>";
        }

        return $html . $this->_getFooterHtml($element);
    }
}
